<?php
/**
 * SCREETS © 2024
 *
 * SCREETS, d.o.o. Sarajevo. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 *
 * @package scxi
 * @author screets
 * @link https://screets.io
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * List of translatable strings of chat widget.
 *
 * title => [sectionTitle, string, isMultiline]
 */
return array(

  // header
  array('header.title' => array('header', 'Contact {siteName}', false)),
  array('header.hiUser' => array('', 'Hello {name}', false)),
  array('header.askUs' => array('', 'Ask our team', false)),
  array('header.replyTime' => array('', ' We typically reply in {time}', false)),

  // topic
  array('topic.sel' => array('topic', 'Select a topic', false )),
  
  // actions
  array('act.chatNow' => array('act', 'Chat now', false)),
  array('act.endNow' => array('', 'End chat', false)),
  array('act.ok' => array('', 'Okay', false)),
  array('act.noThx' => array('', 'No thanks', false)),
  array('act.ntfMe' => array('', 'Notify me', false)),
  array('act.sendMsg' => array('', 'Send message', false)),
    
  // chat
  array('chat.cno' => array('chat', 'Case number', false)),
  array('chat.new' => array('', 'New chat', false)),
  array('chat.newMsg' => array('', '{name} sent you a message', false)),
  array('chat.waitingHeader' => array('', "We'll connect you to an advisor.", false)),
  array('chat.connectedHeader' => array('', "You're connected with {opName}.", false)),
  array('chat.online' => array('', 'Available', false)),
  array('chat.ended' => array('', 'This chat ended', false)),

  // pre-chat
  array('prechat.title' => array('prechat', 'We\'ll connect you to an expert.', false)),
  array('prechat.agree' => array('', 'I agree to have my personal data processed by {companyName} for chat support.', true)),
  
  // chats
  array('cnvs._' => array('cnvs', 'Chat | Chats', false)),

  // collector card
  array('bots.askContact.s1' => array('collectorCard', 'We typically reply in {time}', false)),
  array('bots.askContact.s2' => array('', 'Give the team a way to reach you:', false)),
  array('bots.askContact.s3' => array('', 'Get notified by email', false)),
  array('bots.askContact.done1' => array('', "You'll be notified here and by email.", true)),

  // inbox
  array('inbox.empty' => array('inbox', 'No chats found.', false)),

  // notifications
  array('ntf.seen' => array('ntf', 'Seen', false)),
  array('ntf.sending' => array('', 'Sending', false)),
  array('ntf.sent' => array('', 'Sent', false)),
  array('ntf.sentSuccess' => array('', 'sentSuccess', false)),
  array('ntf.uploading' => array('', 'File is uploading. Please wait...', false)),
  array('ntf.askAudioPerm' => array('', 'We\'d like to send you audio notifications during this chat. If you choose to receive audio notifications, make sure your speaker volume is turned up.', false)),
  array('ntf.sureEndChat' => array('', 'Are you sure you want to end this chat?', false)),

  // errors
  array('err.na' => array('err', 'Something went wrong! Please try again', false)),
  array('err.reqField' => array('', 'Field is required', false)),
  array('err.invEmail' => array('', 'Email is invalid', false)),
  array('err.invTel' => array('', 'Phone number is invalid', false)),
  array('err.uplFail' => array('', 'Unable to upload file', false)),

  // offline form
  array('offline.desc' => array('offline', "We aren't online at the moment, but leave your questions and your email here and we'll get back to you, asap.", true)),
  array('offline.yourMsg' => array('', 'Your message', false)),
  array('offline.summary' => array('', 'Summary', false)),
  array('offline.summaryHint' => array('', 'In a few words, tell us what your enquiry is about', false)),
  array('offline.msg' => array('', 'Provide a detailed description', false)),

  // profile fields
  array('profile.name' => array('profile', 'Your name', false)),
  array('profile.email' => array('', 'Email', false)),
  array('profile.emailNew' => array('', 'Enter your email', false)),
  array('profile.emailHint' => array('', 'We will contact you from this email if you aren\'t online', true)),
  array('profile.tel' => array('', 'Phone', false)),
  array('profile.telNew' => array('', 'Your phone number', false)),
  array('profile.telHint' => array('', 'i.e. +1 (541) 754 3010', false)),

  // privacy
  array('privacy.formFootNote' => array('privacy', 'This form collects submitted data so that we can correspond with you.', true)),

  // composer (reply)
  array('reply.ph' => array('reply', 'Enter your message...', false)),
  array('reply.phWelc' => array('', 'Tell us what your enquiry is about', false)),

  // general
  array('general.you' => array('general', 'You', false)),
  array('general.optional' => array('', 'Optional', false)),

  // response time
  array('rts._' => array('rts', 'Replies in {time}', false)),
  array('rts.m' => array('', 'a minute', false)),
  array('rts.ms' => array('', 'a few minutes', false)),
  array('rts.h' => array('', 'an hour', false)),
  array('rts.d' => array('', 'a day', false)),
  array('rts.ds' => array('', 'a few days', false)),
  array('rts.dx' => array('', '{day} days', false)),
  array('rts.bd' => array('', '1 business day', false)),
  array('rts.bdx' => array('', '{day} business days', false)),

  // data & time
  array('time.future' => array('time', 'in %s', false )),
  array('time.past' => array('', '%s', false )),
  array('time.s' => array('', 'Just now', false )),
  array('time.m' => array('', '1m ago', false )),
  array('time.mm' => array('', '%dm ago', false )),
  array('time.h' => array('', '1h ago', false )),
  array('time.hh' => array('', '%dh ago', false )),
  array('time.d' => array('', '1d ago', false )),
  array('time.dd' => array('', '%dd ago', false )),
  array('time.M' => array('', '1m ago', false )),
  array('time.MM' => array('', '%dm ago', false )),
  array('time.y' => array('', '1y ago', false )),
  array('time.yy' => array('', '%dy ago', false )),
);